/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.gui.components;

import com.github.charlyb01.music_control.categories.Music;
import com.github.charlyb01.music_control.config.ModConfig;
import com.github.charlyb01.music_control.gui.components.Button;
import com.github.charlyb01.music_control.gui.components.ButtonListPanel;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.widget.TooltipBuilder;
import io.github.cottonmc.cotton.gui.widget.WBox;
import io.github.cottonmc.cotton.gui.widget.WCardPanel;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WToggleButton;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class SoundConfigPanel
extends WBox {
    private final WCardPanel cardPanel = new WCardPanel();
    private ButtonListPanel addAnyListPanel;
    private ButtonListPanel removeAnyListPanel;
    private ButtonListPanel addEventListPanel;
    private ButtonListPanel removeEventListPanel;

    public SoundConfigPanel(class_2960 sound, boolean isEvent, int width) {
        super(Axis.VERTICAL);
        this.setupBar(isEvent);
        this.setupAnyListPanel(sound, isEvent, width);
        this.setupEventListPanel(sound, width);
        this.cardPanel.add((WWidget)this.removeAnyListPanel);
        this.cardPanel.add((WWidget)this.addAnyListPanel);
        this.cardPanel.add((WWidget)this.removeEventListPanel);
        this.cardPanel.add((WWidget)this.addEventListPanel);
        this.add((WWidget)this.cardPanel);
    }

    private void onButtonUpdate(boolean doAdd, boolean isEvent, boolean fromEvent, WLabel label) {
        ButtonListPanel panel = doAdd ? (isEvent ? this.addEventListPanel : this.addAnyListPanel) : (isEvent ? this.removeEventListPanel : this.removeAnyListPanel);
        panel.layout();
        this.cardPanel.setSelectedCard((WWidget)panel);
        class_5250 addText = class_2561.method_43471((String)(doAdd ? "gui.music_control.label.add" : "gui.music_control.label.remove"));
        class_5250 eventText = class_2561.method_43471((String)(!isEvent && fromEvent ? "gui.music_control.label.music" : "gui.music_control.label.event"));
        label.setText(class_2561.method_30163((String)(addText.getString() + eventText.getString())));
    }

    private void setupBar(boolean fromEvent) {
        WToggleButton removeAddButton = new WToggleButton(this){

            public void addTooltip(TooltipBuilder tooltip) {
                super.addTooltip(tooltip);
                tooltip.add(new class_2561[]{class_2561.method_43471((String)"gui.music_control.toggle.removeAdd")});
            }
        };
        WToggleButton musicEventButton = new WToggleButton(this){

            public void addTooltip(TooltipBuilder tooltip) {
                super.addTooltip(tooltip);
                tooltip.add(new class_2561[]{class_2561.method_43471((String)"gui.music_control.toggle.musicEvent")});
            }
        };
        class_5250 addText = class_2561.method_43471((String)"gui.music_control.label.remove");
        class_5250 eventText = class_2561.method_43471((String)(fromEvent ? "gui.music_control.label.music" : "gui.music_control.label.event"));
        WLabel label = new WLabel(class_2561.method_30163((String)(addText.getString() + eventText.getString())));
        label.setVerticalAlignment(VerticalAlignment.CENTER);
        removeAddButton.setOnToggle(doAdd -> this.onButtonUpdate((boolean)doAdd, musicEventButton.getToggle(), fromEvent, label));
        musicEventButton.setOnToggle(isEvent -> this.onButtonUpdate(removeAddButton.getToggle(), (boolean)isEvent, fromEvent, label));
        WBox buttonBar = new WBox(Axis.HORIZONTAL);
        buttonBar.add((WWidget)removeAddButton);
        if (fromEvent) {
            buttonBar.add((WWidget)musicEventButton);
        }
        buttonBar.add((WWidget)label);
        this.add((WWidget)buttonBar);
    }

    private void setupAnyListPanel(class_2960 sound, boolean fromEvent, int width) {
        ArrayList<class_2960> soundToAdd = new ArrayList<class_2960>();
        ArrayList<class_2960> soundToRemove = new ArrayList<class_2960>();
        if (fromEvent) {
            Music.MUSIC_BY_EVENT.get(sound).forEach(music -> soundToRemove.add(music.getIdentifier()));
            for (Music music2 : Music.MUSIC_BY_NAMESPACE.get("all")) {
                if (soundToRemove.contains(music2.getIdentifier())) continue;
                soundToAdd.add(music2.getIdentifier());
            }
        } else {
            Music music3 = Music.getMusicFromIdentifier(sound);
            if (music3 == null) {
                return;
            }
            soundToRemove.addAll(music3.getEvents());
            soundToAdd.addAll(Music.EVENTS);
            for (class_2960 eventId : soundToRemove) {
                soundToAdd.remove(eventId);
            }
        }
        BiConsumer<class_2960, Button> onAdded = (soundClicked, button) -> {
            soundToAdd.remove(soundClicked);
            soundToRemove.add((class_2960)soundClicked);
            soundToRemove.sort(Music.TRANSLATED_ORDER);
            if (fromEvent) {
                Music music = Music.getMusicFromIdentifier(soundClicked);
                if (music != null) {
                    music.addEvent(sound);
                }
            } else {
                Music music = Music.getMusicFromIdentifier(sound);
                if (music != null) {
                    music.addEvent((class_2960)soundClicked);
                }
            }
            this.addAnyListPanel.update();
            this.layout();
        };
        BiConsumer<class_2960, Button> biConsumer = (soundClicked, button) -> {
            soundToRemove.remove(soundClicked);
            soundToAdd.add((class_2960)soundClicked);
            soundToAdd.sort(Music.TRANSLATED_ORDER);
            if (fromEvent) {
                Music music = Music.getMusicFromIdentifier(soundClicked);
                if (music != null) {
                    music.removeEvent(sound);
                }
            } else {
                Music music = Music.getMusicFromIdentifier(sound);
                if (music != null) {
                    music.removeEvent((class_2960)soundClicked);
                }
            }
            this.removeAnyListPanel.update();
            this.layout();
        };
        this.addAnyListPanel = new ButtonListPanel(soundToAdd, onAdded, width, ModConfig.get().cosmetics.gui.height - 20);
        this.removeAnyListPanel = new ButtonListPanel(soundToRemove, biConsumer, width, ModConfig.get().cosmetics.gui.height - 20);
    }

    private void setupEventListPanel(class_2960 sound, int width) {
        ArrayList<class_2960> soundToAdd = new ArrayList<class_2960>(Music.EVENTS);
        ArrayList<class_2960> soundToRemove = new ArrayList<class_2960>();
        if (Music.EVENTS_OF_EVENT.containsKey(sound)) {
            soundToRemove.addAll((Collection)Music.EVENTS_OF_EVENT.get(sound));
        }
        for (class_2960 eventId : soundToRemove) {
            soundToAdd.remove(eventId);
        }
        BiConsumer<class_2960, Button> onAdded = (soundClicked, button) -> {
            soundToAdd.remove(soundClicked);
            soundToRemove.add((class_2960)soundClicked);
            soundToRemove.sort(Music.TRANSLATED_ORDER);
            if (!Music.EVENTS_OF_EVENT.containsKey(sound)) {
                Music.EVENTS_OF_EVENT.put(sound, new HashSet());
            }
            Music.EVENTS_OF_EVENT.get(sound).add((class_2960)soundClicked);
            this.addEventListPanel.update();
            this.layout();
        };
        BiConsumer<class_2960, Button> onRemoved = (soundClicked, button) -> {
            soundToRemove.remove(soundClicked);
            soundToAdd.add((class_2960)soundClicked);
            soundToAdd.sort(Music.TRANSLATED_ORDER);
            Music.EVENTS_OF_EVENT.get(sound).remove(soundClicked);
            if (Music.EVENTS_OF_EVENT.get(sound).isEmpty()) {
                Music.EVENTS_OF_EVENT.remove(sound);
            }
            this.removeEventListPanel.update();
            this.layout();
        };
        this.addEventListPanel = new ButtonListPanel(soundToAdd, onAdded, width, ModConfig.get().cosmetics.gui.height - 20);
        this.removeEventListPanel = new ButtonListPanel(soundToRemove, onRemoved, width, ModConfig.get().cosmetics.gui.height - 20);
    }

    public void setHost(GuiDescription host) {
        super.setHost(host);
        this.addAnyListPanel.setHost(host);
        this.removeAnyListPanel.setHost(host);
        this.addEventListPanel.setHost(host);
        this.removeEventListPanel.setHost(host);
    }
}

